/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.gui;

import com.alrex.parcool.ParCoolConfig;
import com.alrex.parcool.client.gui.ColorTheme;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.ActionList;
import com.alrex.parcool.common.info.ActionInfo;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.common.ForgeConfigSpec;

public class ParCoolSettingScreen
extends Screen {
    private final ConfigSet[] configItemList;
    private SettingMode mode;
    private final Checkbox[] configButtons;
    private final ActionConfigSet[] actionList;
    private final InfoSet[] infoList;
    private final Checkbox[] actionButtons;
    private final ModeSet[] modeMenuList;
    private int modeIndex;
    private int topIndex;
    private int viewableItemCount;
    private static final int Checkbox_Item_Height = 21;
    private final ColorTheme color;
    private final BooleanSupplier serverPermissionReceived;
    private final BooleanSupplier individualPermissionReceived;
    private static final Component MenuTitle = Component.m_237115_((String)"parcool.gui.title.setting");
    private static final Component Header_ActionName = Component.m_237115_((String)"parcool.gui.text.actionName");
    private static final Component Header_ServerPermission = Component.m_237113_((String)"G");
    private static final Component Header_ServerPermissionText = Component.m_237115_((String)"parcool.gui.text.globalPermission");
    private static final Component Header_IndividualPermission = Component.m_237113_((String)"I");
    private static final Component Header_IndividualPermissionText = Component.m_237115_((String)"parcool.gui.text.individualPermission");
    private static final Component Permission_Permitted = Component.m_237113_((String)"\u2713");
    private static final Component Permission_Denied = Component.m_237113_((String)"\u00d7");
    private static final Component Permission_Not_Received = Component.m_237113_((String)"\u00a74Error:Permissions are not sent from a server.\nPlease check whether ParCool is installed or re-login to the server.\u00a7r");

    public ParCoolSettingScreen(Component titleIn, ActionInfo info, ColorTheme theme) {
        super(titleIn);
        int i;
        ConfigSet[] configSetArray = new ConfigSet[17];
        configSetArray[0] = new ConfigSet("Activate ParCool", arg_0 -> ((ForgeConfigSpec.BooleanValue)ParCoolConfig.CONFIG_CLIENT.parCoolActivation).set(arg_0), () -> ((ForgeConfigSpec.BooleanValue)ParCoolConfig.CONFIG_CLIENT.parCoolActivation).get());
        configSetArray[1] = new ConfigSet("Infinite stamina", arg_0 -> ((ForgeConfigSpec.BooleanValue)ParCoolConfig.CONFIG_CLIENT.infiniteStamina).set(arg_0), () -> ((ForgeConfigSpec.BooleanValue)ParCoolConfig.CONFIG_CLIENT.infiniteStamina).get());
        configSetArray[2] = new ConfigSet("Enable actions needing Fast-Run with normal sprint", arg_0 -> ((ForgeConfigSpec.BooleanValue)ParCoolConfig.CONFIG_CLIENT.substituteSprintForFastRun).set(arg_0), () -> ((ForgeConfigSpec.BooleanValue)ParCoolConfig.CONFIG_CLIENT.substituteSprintForFastRun).get());
        configSetArray[3] = new ConfigSet("Always do Fast-Run when doing sprint", arg_0 -> ((ForgeConfigSpec.BooleanValue)ParCoolConfig.CONFIG_CLIENT.replaceSprintWithFastRun).set(arg_0), () -> ((ForgeConfigSpec.BooleanValue)ParCoolConfig.CONFIG_CLIENT.replaceSprintWithFastRun).get());
        configSetArray[4] = new ConfigSet("Hide stamina HUD", arg_0 -> ((ForgeConfigSpec.BooleanValue)ParCoolConfig.CONFIG_CLIENT.hideStaminaHUD).set(arg_0), () -> ((ForgeConfigSpec.BooleanValue)ParCoolConfig.CONFIG_CLIENT.hideStaminaHUD).get());
        configSetArray[5] = new ConfigSet("Use light Stamina HUD", arg_0 -> ((ForgeConfigSpec.BooleanValue)ParCoolConfig.CONFIG_CLIENT.useLightHUD).set(arg_0), () -> ((ForgeConfigSpec.BooleanValue)ParCoolConfig.CONFIG_CLIENT.useLightHUD).get());
        configSetArray[6] = new ConfigSet("Disable a camera rotation of Rolling", arg_0 -> ((ForgeConfigSpec.BooleanValue)ParCoolConfig.CONFIG_CLIENT.disableCameraRolling).set(arg_0), () -> ((ForgeConfigSpec.BooleanValue)ParCoolConfig.CONFIG_CLIENT.disableCameraRolling).get());
        configSetArray[7] = new ConfigSet("Disable a camera rotation of Flipping", arg_0 -> ((ForgeConfigSpec.BooleanValue)ParCoolConfig.CONFIG_CLIENT.disableCameraFlipping).set(arg_0), () -> ((ForgeConfigSpec.BooleanValue)ParCoolConfig.CONFIG_CLIENT.disableCameraFlipping).get());
        configSetArray[8] = new ConfigSet("Disable a camera animation of Horizontal Wall-Run", arg_0 -> ((ForgeConfigSpec.BooleanValue)ParCoolConfig.CONFIG_CLIENT.disableCameraHorizontalWallRun).set(arg_0), () -> ((ForgeConfigSpec.BooleanValue)ParCoolConfig.CONFIG_CLIENT.disableCameraHorizontalWallRun).get());
        configSetArray[9] = new ConfigSet("Disable a camera animation of Vault", arg_0 -> ((ForgeConfigSpec.BooleanValue)ParCoolConfig.CONFIG_CLIENT.disableCameraVault).set(arg_0), () -> ((ForgeConfigSpec.BooleanValue)ParCoolConfig.CONFIG_CLIENT.disableCameraVault).get());
        configSetArray[10] = new ConfigSet("Disable double-tapping for dodge", arg_0 -> ((ForgeConfigSpec.BooleanValue)ParCoolConfig.CONFIG_CLIENT.disableDoubleTappingForDodge).set(arg_0), () -> ((ForgeConfigSpec.BooleanValue)ParCoolConfig.CONFIG_CLIENT.disableDoubleTappingForDodge).get());
        configSetArray[11] = new ConfigSet("Disable crawl in air", arg_0 -> ((ForgeConfigSpec.BooleanValue)ParCoolConfig.CONFIG_CLIENT.disableCrawlInAir).set(arg_0), () -> ((ForgeConfigSpec.BooleanValue)ParCoolConfig.CONFIG_CLIENT.disableCrawlInAir).get());
        configSetArray[12] = new ConfigSet("Disable vault in air", arg_0 -> ((ForgeConfigSpec.BooleanValue)ParCoolConfig.CONFIG_CLIENT.disableVaultInAir).set(arg_0), () -> ((ForgeConfigSpec.BooleanValue)ParCoolConfig.CONFIG_CLIENT.disableVaultInAir).get());
        configSetArray[13] = new ConfigSet("Disable falling animation", arg_0 -> ((ForgeConfigSpec.BooleanValue)ParCoolConfig.CONFIG_CLIENT.disableFallingAnimation).set(arg_0), () -> ((ForgeConfigSpec.BooleanValue)ParCoolConfig.CONFIG_CLIENT.disableFallingAnimation).get());
        configSetArray[14] = new ConfigSet("Disable all animations", arg_0 -> ((ForgeConfigSpec.BooleanValue)ParCoolConfig.CONFIG_CLIENT.disableAnimation).set(arg_0), () -> ((ForgeConfigSpec.BooleanValue)ParCoolConfig.CONFIG_CLIENT.disableAnimation).get());
        configSetArray[15] = new ConfigSet("Disable first person view animations", arg_0 -> ((ForgeConfigSpec.BooleanValue)ParCoolConfig.CONFIG_CLIENT.disableFPVAnimation).set(arg_0), () -> ((ForgeConfigSpec.BooleanValue)ParCoolConfig.CONFIG_CLIENT.disableFPVAnimation).get());
        configSetArray[16] = new ConfigSet("Enable roll when player is creative", arg_0 -> ((ForgeConfigSpec.BooleanValue)ParCoolConfig.CONFIG_CLIENT.enableRollWhenCreative).set(arg_0), () -> ((ForgeConfigSpec.BooleanValue)ParCoolConfig.CONFIG_CLIENT.enableRollWhenCreative).get());
        this.configItemList = configSetArray;
        this.mode = SettingMode.Actions;
        this.configButtons = new Checkbox[this.configItemList.length];
        this.actionList = new ActionConfigSet[ActionList.ACTIONS.size()];
        this.actionButtons = new Checkbox[this.actionList.length];
        this.modeMenuList = new ModeSet[]{new ModeSet((Component)Component.m_237115_((String)"parcool.gui.text.action"), SettingMode.Actions, 0, this), new ModeSet((Component)Component.m_237115_((String)"parcool.gui.text.config"), SettingMode.Configs, 1, this), new ModeSet((Component)Component.m_237115_((String)"parcool.gui.text.limitation"), SettingMode.Limitations, 2, this)};
        this.topIndex = 0;
        this.viewableItemCount = 0;
        for (i = 0; i < this.actionList.length; ++i) {
            this.actionList[i] = new ActionConfigSet(ActionList.getByIndex(i), info);
            this.actionButtons[i] = new Checkbox(0, 0, 0, 21, (Component)Component.m_237113_((String)this.actionList[i].name), this.actionList[i].getter.getAsBoolean());
        }
        for (i = 0; i < this.configItemList.length; ++i) {
            this.configButtons[i] = new Checkbox(0, 0, 0, 21, (Component)Component.m_237113_((String)this.configItemList[i].name), this.configItemList[i].getter.getAsBoolean());
        }
        this.infoList = new InfoSet[]{new InfoSet("Max Stamina Limitation", Integer.toString(info.getMaxStaminaLimitation())), new InfoSet("Infinite Stamina Permission", Boolean.toString(info.isInfiniteStaminaPermitted()))};
        this.serverPermissionReceived = info.getServerLimitation()::isReceived;
        this.individualPermissionReceived = info.getIndividualLimitation()::isReceived;
        this.color = theme;
    }

    public void m_7379_() {
        int i;
        for (i = 0; i < this.configItemList.length; ++i) {
            this.configItemList[i].setter.accept(this.configButtons[i].m_93840_());
        }
        for (i = 0; i < this.actionList.length; ++i) {
            this.actionList[i].setter.accept(this.actionButtons[i].m_93840_());
        }
        super.m_7379_();
    }

    public void m_6574_(Minecraft p_231152_1_, int p_231152_2_, int p_231152_3_) {
        super.m_6574_(p_231152_1_, p_231152_2_, p_231152_3_);
        this.m_6050_(0.0, 0.0, 0.0);
    }

    public void m_6305_(@Nonnull PoseStack matrixStack, int mouseX, int mouseY, float p_230430_4_) {
        super.m_6305_(matrixStack, mouseX, mouseY, p_230430_4_);
        this.m_96558_(matrixStack, 0);
        Objects.requireNonNull(this.f_96547_);
        int topBarHeight = 9 * 2;
        int topBarItemWidth = (int)(1.6 * (double)Arrays.stream(this.modeMenuList).map(it -> this.f_96547_.m_92852_((FormattedText)it.title)).max(Integer::compareTo).orElse(0).intValue());
        int topBarOffsetX = this.f_96543_ - topBarItemWidth * this.modeMenuList.length;
        this.m_93179_(matrixStack, 0, 0, this.f_96543_, topBarHeight, this.color.getTopBar1(), this.color.getTopBar2());
        ParCoolSettingScreen.m_93243_((PoseStack)matrixStack, (Font)this.f_96547_, (Component)MenuTitle, (int)10, (int)(topBarHeight / 4 + 1), (int)this.color.getText());
        for (int i = 0; i < this.modeMenuList.length; ++i) {
            ModeSet item = this.modeMenuList[i];
            item.y = 0;
            item.x = topBarOffsetX + i * topBarItemWidth;
            item.width = topBarItemWidth;
            item.height = topBarHeight;
            boolean selected = item.mode == this.mode || item.isMouseIn(mouseX, mouseY);
            ParCoolSettingScreen.m_93215_((PoseStack)matrixStack, (Font)this.f_96547_, (Component)item.title, (int)(topBarOffsetX + i * topBarItemWidth + topBarItemWidth / 2), (int)(topBarHeight / 4 + 1), (int)(selected ? this.color.getText() : this.color.getSubText()));
            ParCoolSettingScreen.m_93172_((PoseStack)matrixStack, (int)item.x, (int)2, (int)(item.x + 1), (int)(topBarHeight - 3), (int)this.color.getSeparator());
        }
        ParCoolSettingScreen.m_93172_((PoseStack)matrixStack, (int)0, (int)(topBarHeight - 1), (int)this.f_96543_, (int)topBarHeight, (int)this.color.getSeparator());
        switch (this.mode) {
            case Actions: {
                this.renderActions(matrixStack, mouseX, mouseY, p_230430_4_, topBarHeight);
                break;
            }
            case Configs: {
                this.renderConfigs(matrixStack, mouseX, mouseY, p_230430_4_, topBarHeight);
                break;
            }
            case Limitations: {
                this.renderLimitations(matrixStack, mouseX, mouseY, p_230430_4_, topBarHeight);
            }
        }
    }

    private void renderActions(PoseStack matrixStack, int mouseX, int mouseY, float p_230430_4_, int offsetY) {
        int offsetX = 40;
        Objects.requireNonNull(this.f_96547_);
        int headerHeight = (int)(9.0f * 1.5f);
        Objects.requireNonNull(this.f_96547_);
        int headerOffsetY = offsetY + 9 * 2;
        int contentOffsetY = headerOffsetY + headerHeight + 2;
        int permissionColumnWidth = this.f_96547_.m_92852_((FormattedText)Permission_Permitted) * 5;
        int nameColumnWidth = this.f_96543_ - offsetX * 2 - permissionColumnWidth * 2;
        Objects.requireNonNull(this.f_96547_);
        int contentHeight = this.f_96544_ - contentOffsetY - 9 * 2;
        this.viewableItemCount = contentHeight / 21;
        int n = headerOffsetY + headerHeight / 2;
        Objects.requireNonNull(this.f_96547_);
        int headerTextY = n - 9 / 2 + 1;
        ParCoolSettingScreen.m_93243_((PoseStack)matrixStack, (Font)this.f_96547_, (Component)Header_ActionName, (int)(offsetX + 5), (int)headerTextY, (int)this.color.getText());
        ParCoolSettingScreen.m_93215_((PoseStack)matrixStack, (Font)this.f_96547_, (Component)Header_ServerPermission, (int)(offsetX + nameColumnWidth + permissionColumnWidth / 2), (int)headerTextY, (int)this.color.getText());
        ParCoolSettingScreen.m_93215_((PoseStack)matrixStack, (Font)this.f_96547_, (Component)Header_IndividualPermission, (int)(offsetX + nameColumnWidth + permissionColumnWidth + permissionColumnWidth / 2), (int)headerTextY, (int)this.color.getText());
        for (Checkbox actionButton : this.actionButtons) {
            actionButton.m_93674_(0);
        }
        for (int i = 0; i < this.viewableItemCount && i + this.topIndex < this.actionButtons.length; ++i) {
            Checkbox button = this.actionButtons[i + this.topIndex];
            button.f_93620_ = offsetX + 1;
            button.f_93621_ = contentOffsetY + 21 * i;
            button.m_93674_(nameColumnWidth - 5);
            button.setHeight(20);
            button.m_6305_(matrixStack, mouseX, mouseY, p_230430_4_);
            ParCoolSettingScreen.m_93172_((PoseStack)matrixStack, (int)offsetX, (int)(button.f_93621_ + button.m_93694_()), (int)(this.f_96543_ - offsetX), (int)(button.f_93621_ + button.m_93694_() + 1), (int)this.color.getSubSeparator());
            int rowY = contentOffsetY + 21 * i + 10;
            boolean permitted = this.actionList[this.topIndex + i].serverWideLimitation.getAsBoolean();
            Component component = permitted ? Permission_Permitted : Permission_Denied;
            int n2 = offsetX + nameColumnWidth + permissionColumnWidth / 2;
            Objects.requireNonNull(this.f_96547_);
            ParCoolSettingScreen.m_93215_((PoseStack)matrixStack, (Font)this.f_96547_, (Component)component, (int)n2, (int)(rowY - 9 / 2), (int)(permitted ? 43520 : 0xAA0000));
            permitted = this.actionList[this.topIndex + i].individualLimitation.getAsBoolean();
            Component component2 = permitted ? Permission_Permitted : Permission_Denied;
            int n3 = offsetX + nameColumnWidth + permissionColumnWidth + permissionColumnWidth / 2;
            Objects.requireNonNull(this.f_96547_);
            ParCoolSettingScreen.m_93215_((PoseStack)matrixStack, (Font)this.f_96547_, (Component)component2, (int)n3, (int)(rowY - 9 / 2), (int)(permitted ? 43520 : 0xAA0000));
        }
        this.m_93179_(matrixStack, 0, offsetY, this.f_96543_, headerOffsetY, this.color.getHeader1(), this.color.getHeader2());
        this.m_93179_(matrixStack, 0, contentOffsetY + contentHeight, this.f_96543_, this.f_96544_, this.color.getHeader1(), this.color.getHeader2());
        Component component = this.modeMenuList[0].title;
        int n4 = this.f_96543_ / 2;
        Objects.requireNonNull(this.f_96547_);
        ParCoolSettingScreen.m_93215_((PoseStack)matrixStack, (Font)this.f_96547_, (Component)component, (int)n4, (int)(offsetY + 9 / 2 + 2), (int)this.color.getStrongText());
        if (this.topIndex + this.viewableItemCount < this.actionButtons.length) {
            MutableComponent mutableComponent = Component.m_237113_((String)"\u2193");
            int n5 = this.f_96543_ / 2;
            Objects.requireNonNull(this.f_96547_);
            Objects.requireNonNull(this.f_96547_);
            ParCoolSettingScreen.m_93215_((PoseStack)matrixStack, (Font)this.f_96547_, (Component)mutableComponent, (int)n5, (int)(this.f_96544_ - 9 - 9 / 2), (int)this.color.getStrongText());
        }
        ParCoolSettingScreen.m_93172_((PoseStack)matrixStack, (int)offsetX, (int)contentOffsetY, (int)(this.f_96543_ - offsetX), (int)(contentOffsetY - 1), (int)this.color.getSeparator());
        ParCoolSettingScreen.m_93172_((PoseStack)matrixStack, (int)offsetX, (int)headerOffsetY, (int)(offsetX + 1), (int)(contentOffsetY + contentHeight), (int)this.color.getSeparator());
        ParCoolSettingScreen.m_93172_((PoseStack)matrixStack, (int)(offsetX + nameColumnWidth), (int)headerOffsetY, (int)(offsetX + nameColumnWidth + 1), (int)(contentOffsetY + contentHeight), (int)this.color.getSeparator());
        ParCoolSettingScreen.m_93172_((PoseStack)matrixStack, (int)(offsetX + nameColumnWidth + permissionColumnWidth), (int)headerOffsetY, (int)(offsetX + nameColumnWidth + permissionColumnWidth + 1), (int)(contentOffsetY + contentHeight), (int)this.color.getSeparator());
        ParCoolSettingScreen.m_93172_((PoseStack)matrixStack, (int)(offsetX + nameColumnWidth + permissionColumnWidth * 2), (int)headerOffsetY, (int)(offsetX + nameColumnWidth + permissionColumnWidth * 2 + 1), (int)(contentOffsetY + contentHeight), (int)this.color.getSeparator());
        int columnCenter = offsetX + nameColumnWidth + permissionColumnWidth / 2;
        if (headerOffsetY < mouseY && mouseY < headerOffsetY + headerHeight && columnCenter - permissionColumnWidth / 2 < mouseX && mouseX < columnCenter + permissionColumnWidth / 2) {
            if (this.serverPermissionReceived.getAsBoolean()) {
                this.m_96597_(matrixStack, Collections.singletonList(Header_ServerPermissionText), mouseX, mouseY);
            } else {
                this.m_96597_(matrixStack, Arrays.asList(Header_ServerPermissionText, Permission_Not_Received), mouseX, mouseY);
            }
        }
        columnCenter = offsetX + nameColumnWidth + permissionColumnWidth + permissionColumnWidth / 2;
        if (headerOffsetY < mouseY && mouseY < headerOffsetY + headerHeight && columnCenter - permissionColumnWidth / 2 < mouseX && mouseX < columnCenter + permissionColumnWidth / 2) {
            if (this.individualPermissionReceived.getAsBoolean()) {
                this.m_96597_(matrixStack, Collections.singletonList(Header_IndividualPermissionText), mouseX, mouseY);
            } else {
                this.m_96597_(matrixStack, Arrays.asList(Header_IndividualPermissionText, Permission_Not_Received), mouseX, mouseY);
            }
        }
    }

    private void renderConfigs(PoseStack matrixStack, int mouseX, int mouseY, float p_230430_4_, int offsetY) {
        int offsetX = 40;
        int contentWidth = this.f_96543_ - offsetX * 2;
        Objects.requireNonNull(this.f_96547_);
        int contentHeight = this.f_96544_ - offsetY - 9 * 4;
        Objects.requireNonNull(this.f_96547_);
        int contentOffsetY = offsetY + 9 * 2;
        this.viewableItemCount = contentHeight / 21;
        for (Checkbox configButton : this.configButtons) {
            configButton.m_93674_(0);
        }
        for (int i = 0; i < this.viewableItemCount && i + this.topIndex < this.configItemList.length; ++i) {
            Checkbox button = this.configButtons[i + this.topIndex];
            button.f_93620_ = offsetX + 1;
            Objects.requireNonNull(this.f_96547_);
            button.f_93621_ = offsetY + 9 * 2 + 21 * i;
            button.m_93674_(contentWidth);
            button.setHeight(20);
            button.m_6305_(matrixStack, mouseX, mouseY, p_230430_4_);
            ParCoolSettingScreen.m_93172_((PoseStack)matrixStack, (int)offsetX, (int)(button.f_93621_ + button.m_93694_()), (int)(this.f_96543_ - offsetX), (int)(button.f_93621_ + button.m_93694_() + 1), (int)this.color.getSubSeparator());
        }
        ParCoolSettingScreen.m_93172_((PoseStack)matrixStack, (int)(this.f_96543_ - offsetX), (int)contentOffsetY, (int)(this.f_96543_ - offsetX - 1), (int)(contentOffsetY + contentHeight), (int)this.color.getSeparator());
        ParCoolSettingScreen.m_93172_((PoseStack)matrixStack, (int)offsetX, (int)contentOffsetY, (int)(offsetX + 1), (int)(contentOffsetY + contentHeight), (int)this.color.getSeparator());
        Objects.requireNonNull(this.f_96547_);
        this.m_93179_(matrixStack, 0, offsetY, this.f_96543_, offsetY + 9 * 2, this.color.getHeader1(), this.color.getHeader2());
        Objects.requireNonNull(this.f_96547_);
        this.m_93179_(matrixStack, 0, offsetY + contentHeight + 9 * 2, this.f_96543_, this.f_96544_, this.color.getHeader1(), this.color.getHeader2());
        Component component = this.modeMenuList[1].title;
        int n = this.f_96543_ / 2;
        Objects.requireNonNull(this.f_96547_);
        ParCoolSettingScreen.m_93215_((PoseStack)matrixStack, (Font)this.f_96547_, (Component)component, (int)n, (int)(offsetY + 9 / 2 + 2), (int)this.color.getStrongText());
        if (this.topIndex + this.viewableItemCount < this.configButtons.length) {
            MutableComponent mutableComponent = Component.m_237113_((String)"\u2193");
            int n2 = this.f_96543_ / 2;
            Objects.requireNonNull(this.f_96547_);
            Objects.requireNonNull(this.f_96547_);
            ParCoolSettingScreen.m_93215_((PoseStack)matrixStack, (Font)this.f_96547_, (Component)mutableComponent, (int)n2, (int)(this.f_96544_ - 9 - 9 / 2), (int)this.color.getSubText());
        }
    }

    private void renderLimitations(PoseStack matrixStack, int mouseX, int mouseY, float p_230430_4_, int offsetY) {
        int offsetX = 40;
        Objects.requireNonNull(this.f_96547_);
        int contentHeight = this.f_96544_ - offsetY - 9 * 4;
        Objects.requireNonNull(this.f_96547_);
        int contentOffsetY = offsetY + 9 * 2;
        Objects.requireNonNull(this.f_96547_);
        int itemHeight = 9 * 2;
        int valueWidth = Arrays.stream(this.infoList).map(it -> this.f_96547_.m_92895_(it.value)).max(Integer::compareTo).orElse(0);
        for (int i = 0; i < this.infoList.length; ++i) {
            InfoSet item = this.infoList[i];
            String string = item.name;
            int n = contentOffsetY + itemHeight * i + itemHeight / 2;
            Objects.requireNonNull(this.f_96547_);
            ParCoolSettingScreen.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)string, (int)(offsetX + 5), (int)(n - 9 / 2), (int)this.color.getText());
            String string2 = item.value;
            int n2 = contentOffsetY + itemHeight * i + itemHeight / 2;
            Objects.requireNonNull(this.f_96547_);
            ParCoolSettingScreen.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)string2, (int)(this.f_96543_ - offsetX - 5 - valueWidth), (int)(n2 - 9 / 2), (int)this.color.getText());
            ParCoolSettingScreen.m_93172_((PoseStack)matrixStack, (int)offsetX, (int)(contentOffsetY + itemHeight * (i + 1)), (int)(this.f_96543_ - offsetX), (int)(contentOffsetY + itemHeight * (i + 1) + 1), (int)this.color.getSubSeparator());
        }
        ParCoolSettingScreen.m_93172_((PoseStack)matrixStack, (int)(this.f_96543_ - offsetX), (int)contentOffsetY, (int)(this.f_96543_ - offsetX - 1), (int)(contentOffsetY + contentHeight), (int)this.color.getSeparator());
        ParCoolSettingScreen.m_93172_((PoseStack)matrixStack, (int)offsetX, (int)contentOffsetY, (int)(offsetX + 1), (int)(contentOffsetY + contentHeight), (int)this.color.getSeparator());
        Objects.requireNonNull(this.f_96547_);
        this.m_93179_(matrixStack, 0, offsetY, this.f_96543_, offsetY + 9 * 2, this.color.getHeader1(), this.color.getHeader2());
        Objects.requireNonNull(this.f_96547_);
        this.m_93179_(matrixStack, 0, offsetY + contentHeight + 9 * 2, this.f_96543_, this.f_96544_, this.color.getHeader1(), this.color.getHeader2());
        Component component = this.modeMenuList[2].title;
        int n = this.f_96543_ / 2;
        Objects.requireNonNull(this.f_96547_);
        ParCoolSettingScreen.m_93215_((PoseStack)matrixStack, (Font)this.f_96547_, (Component)component, (int)n, (int)(offsetY + 9 / 2 + 2), (int)0x8888FF);
    }

    public void m_96558_(@Nonnull PoseStack p_238651_1_, int p_238651_2_) {
        ParCoolSettingScreen.m_93172_((PoseStack)p_238651_1_, (int)0, (int)0, (int)this.f_96543_, (int)this.f_96544_, (int)this.color.getBackground());
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        switch (keyCode) {
            case 262: {
                if (this.modeIndex >= this.modeMenuList.length - 1) break;
                ++this.modeIndex;
                this.modeMenuList[this.modeIndex].set();
                break;
            }
            case 263: {
                if (this.modeIndex <= 0) break;
                --this.modeIndex;
                this.modeMenuList[this.modeIndex].set();
                break;
            }
            case 265: {
                this.m_6050_(0.0, 0.0, 1.0);
                break;
            }
            case 264: {
                this.m_6050_(0.0, 0.0, -1.0);
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6050_(double x, double y, double value) {
        this.topIndex -= (int)Math.signum(value);
        switch (this.mode) {
            case Actions: {
                if (this.topIndex <= this.actionButtons.length - this.viewableItemCount) break;
                this.topIndex = this.actionButtons.length - this.viewableItemCount;
                break;
            }
            case Configs: {
                if (this.topIndex <= this.configButtons.length - this.viewableItemCount) break;
                this.topIndex = this.configButtons.length - this.viewableItemCount;
            }
        }
        if (this.topIndex < 0) {
            this.topIndex = 0;
        }
        return true;
    }

    public boolean m_6375_(double mouseX, double mouseY, int type) {
        for (ModeSet modeSet : this.modeMenuList) {
            if (!modeSet.isMouseIn((int)mouseX, (int)mouseY) || type != 0) continue;
            modeSet.set();
            return true;
        }
        switch (this.mode) {
            case Actions: {
                for (ModeSet modeSet : this.actionButtons) {
                    modeSet.m_6375_(mouseX, mouseY, type);
                }
                break;
            }
            case Configs: {
                for (ModeSet modeSet : this.configButtons) {
                    modeSet.m_6375_(mouseX, mouseY, type);
                }
                break;
            }
        }
        return false;
    }

    private static class ConfigSet {
        final String name;
        final Consumer<Boolean> setter;
        final BooleanSupplier getter;

        ConfigSet(String name, Consumer<Boolean> setter, BooleanSupplier getter) {
            this.name = name;
            this.getter = getter;
            this.setter = setter;
        }
    }

    private static enum SettingMode {
        Actions,
        Configs,
        Limitations;

    }

    private static class ActionConfigSet {
        final String name;
        final Consumer<Boolean> setter;
        final BooleanSupplier getter;
        final BooleanSupplier serverWideLimitation;
        final BooleanSupplier individualLimitation;

        ActionConfigSet(Class<? extends Action> action, ActionInfo info) {
            this.name = Component.m_237115_((String)("parcool.action." + action.getSimpleName())).getString();
            ForgeConfigSpec.BooleanValue config = ParCoolConfig.CONFIG_CLIENT.getPossibilityOf(action);
            this.setter = arg_0 -> ((ForgeConfigSpec.BooleanValue)config).set(arg_0);
            this.getter = () -> ((ForgeConfigSpec.BooleanValue)config).get();
            this.serverWideLimitation = () -> info.getServerLimitation().isPermitted(action);
            this.individualLimitation = () -> info.getIndividualLimitation().isPermitted(action);
        }
    }

    private static class ModeSet {
        final Component title;
        final SettingMode mode;
        final ParCoolSettingScreen parent;
        final int index;
        int x = 0;
        int y = 0;
        int width = 0;
        int height = 0;

        ModeSet(Component title, SettingMode mode, int index, ParCoolSettingScreen parent) {
            this.title = title;
            this.index = index;
            this.mode = mode;
            this.parent = parent;
        }

        void set() {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
            this.parent.topIndex = 0;
            this.parent.mode = this.mode;
            this.parent.modeIndex = this.index;
        }

        boolean isMouseIn(int mouseX, int mouseY) {
            return this.x < mouseX && mouseX < this.x + this.width && this.y < mouseY && mouseY < this.y + this.height;
        }
    }

    private static class InfoSet {
        final String name;
        final String value;

        InfoSet(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

